--Autor: Radoslav Golian
--Popis: Skript vytvara objekty pre testovanie vykonu autorizovanych pohladov

-- nacitame parametre
@params.sql

-- umoznime pouzitie inicializacnych parametrov
set define on
set echo on

prompt Prihlasime sa ako pouzivatel &user_name
connect &user_name/&user_pass&db_name

prompt vytvorime sekvenciu, ktora bude generovat id, pre testovaciu tabulku
create sequence seq_test_table_id
/

pause Pre pokracovanie stlacte Enter

prompt Vytvorime testovaciu tabulku so &row_count zaznamami
create table test_table as
select
  seq_test_table_id.nextval as id,
  mod(level, 7) as num
from dual
connect by level <= &row_count
/

pause Pre pokracovanie stlacte Enter

prompt vytvorime specifikaciu balika, v ktorom bude nastavovana globalna premmena
create or replace package mutable is
   procedure set_num(p_num IN test_table.num%TYPE);
   function get_num return test_table.num%TYPE;
end mutable;
/

pause Pre pokracovanie stlacte Enter

prompt Vytvorime telo balika, ktory bude nastavovat globalnu premennu
create or replace package body mutable is

   g_num test_table.num%TYPE := null;

   procedure set_num(p_num IN test_table.num%TYPE) is
   begin
      g_num := p_num;
   end set_num;

   function get_num return test_table.num%TYPE is
   begin
      return g_num;
   end get_num;

end mutable;
/

pause Pre pokracovanie stlacte Enter

prompt Vytvorime specifikaciu balika, ktory bude zviazany s aplikacnynm kontextom
CREATE OR REPLACE PACKAGE ctx_mutable_pkg IS
  PROCEDURE set_num(p_num IN test_table.num%TYPE);
  PROCEDURE clear_num;
END ctx_mutable_pkg;
/

pause Pre pokracovanie stlacte Enter

prompt Vytvorime telo balika zviazaneho s aplikacnym kontextom

CREATE OR REPLACE PACKAGE BODY ctx_mutable_pkg IS
  PROCEDURE set_num(p_num IN test_table.num%TYPE) IS
  BEGIN
    dbms_session.set_context(
      namespace => 'ctx_mutable',
      attribute => 'num',
      value => p_num);
  END set_num;

  PROCEDURE clear_num IS
  BEGIN
    dbms_session.clear_context(
      namespace => 'ctx_mutable',
      attribute => 'num');
  END clear_num;

END ctx_mutable_pkg;
/

pause Pre pokracovanie stlacte Enter

prompt Vytvorime aplikacny kontext
CREATE CONTEXT ctx_mutable USING &user_name .ctx_mutable_pkg
/

pause Pre pokracovanie stlacte Enter


prompt Vytvorime pohlad, ktory pouziva premennu z balika
CREATE VIEW package_view AS
  SELECT *
  FROM test_table
  WHERE num = mutable.get_num
WITH CHECK OPTION
/
pause Pre pokracovanie stlacte Enter

prompt Vytvorime pohlad, ktory pouziva premenu z aplikacneho kontextu
CREATE VIEW context_view AS
  SELECT *
  FROM test_table
  WHERE num = sys_context('ctx_mutable', 'num')
WITH CHECK OPTION
/

pause Pre pokracovanie stlacte Enter
prompt Ukoncime spojenie
exit


